<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

/**
 * class for perfoming all Home related functions
 *
 * @author   Nextloop.net
 * @access   public
 * @see      http://www.nextloop.net
 */
class Home extends MY_Controller
{

    /**
     * constructor method
     */
    public function __construct()
    {

        parent::__construct();

        //profiling::
        $this->data['controller_profiling'][] = __function__;

        //template file
        $this->data['template_file'] = PATHS_ADMIN_THEME . 'home.html';

        //css settings
        $this->data['vars']['css_menu_dashboard'] = 'open'; //menu

        //default page title
        $this->data['vars']['main_title'] = $this->data['lang']['lang_dashboard'];
        $this->data['vars']['main_title_icon'] = '<i class="icon-home"></i>';

    }

    function index()
    {

        //profiling::
        $this->data['controller_profiling'][] = __function__;

        //login check
        $this->__commonAdmin_LoggedInCheck();

        //uri - action segment
        $action = $this->uri->segment(3);

        //refresh task status (all tasks)
        $this->refresh->taskStatus('all');

        //get data
        $this->__pulldownLists();

        //re-route to correct method
        switch ($action) {

            case 'edit-task':
                $this->__editTask();
                break;

            default:
                $this->__home();
        }

        //load view
        $this->__flmView('admin/main');

    }

    /**
     * loads the main dashboard
     */
    function __home()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //payments data
        $this->data['reg_fields'][] = 'payments_sum';
        $this->data['fields']['payments_sum'] = $this->payments_model->periodicPaymentsSum('all', '');


        //load members pinned projects
        $this->__pinnedProjects();

        //due invoices
        $this->__dueInvoices();

        //load members tasks
        $this->__myTasks();

        //data for stats charts
        $this->__allTaskStats();

        //data for stats charts
        $this->__allProjectsStats();

        //my projects timeline
        $this->__getEventsTimeline();

    }

    /**
     * get stats for all tasks in the system (active projects only)
     */
    function __allTaskStats()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        $this->data['reg_fields'][] = 'stats_tasks';

        //open
        $this->data['fields']['stats_tasks']['pending'] = $this->tasks_model->countTasks('', '', 'pending', 'all');
        //pending
        $this->data['fields']['stats_tasks']['behind'] = $this->tasks_model->countTasks('', '', 'behind schedule', 'all');
        //pending
        $this->data['fields']['stats_tasks']['completed'] = $this->tasks_model->countTasks('', '', 'completed', 'all');
    }


    /**
     * get stats for all projects in the system (active projects only)
     */
    function __allProjectsStats()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        $this->data['reg_fields'][] = 'stats_projects';

        //open
        $this->data['fields']['stats_projects']['pending'] = $this->projects_model->countProjects('', 'all', 'in progress');
        //pending
        $this->data['fields']['stats_projects']['behind'] = $this->projects_model->countProjects('', 'all', 'behind schedule');
        //pending
        $this->data['fields']['stats_projects']['completed'] = $this->projects_model->countProjects('', 'all', 'completed');
    }
    /**
     * sum up my invoices
     */
    function __dueInvoices()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //sum up all 'due' invoices
        $due_invoices = $this->invoices_model->dueInvoices('all', '', 'due');

        $this->data['vars']['due_invoices'] = '';
        for ($i = 0; $i < count($due_invoices); $i++) {
            $this->data['vars']['due_invoices'] += $due_invoices[$i]['amount_due'];
        }

        //sum up all 'overdue' invoices
        $overdue_invoices = $this->invoices_model->dueInvoices('all', '', 'overdue');

        $this->data['vars']['overdue_invoices'] = '';
        for ($i = 0; $i < count($overdue_invoices); $i++) {
            $this->data['vars']['overdue_invoices'] += $overdue_invoices[$i]['amount_due'];
        }

    }

    /**
     * load some of my pinned projects
     */
    function __pinnedProjects()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        $next = true;

        //create list of my 4 pinned projects
        if ($next) {
            $counter = false;
            for ($i = 1; $i < 5; $i++) {
                $pinned = $this->data['vars']["my_pinned_project_$i"];
                if (in_array($pinned, $this->data['vars']['my_projects_array'])) {
                    //get the project
                    if ($project = $this->projects_model->getPinnedProject($pinned, $this->data['vars']['my_id'])) {
                        $this->data['reg_fields'][] = "my_pinned_project_$i";
                        $this->data['fields']["my_pinned_project_$i"] = $project;
                        $this->data['visible']["my_pinned_project_$i"] = 1;
                        $counter = true;
                    } else {
                        $this->data['visible']["my_pinned_project_$i"] = 0;
                    }
                } else {
                    $this->data['visible']["my_pinned_project_$i"] = 0;
                }
            }
        }

        //nothing to show
        if ($next) {
            if (!$counter) {
                $this->data['visible']["no_pinned_projects"] = 1;
            }
        }


    }

    /**
     * load some of my tasks
     */
    function __myTasks()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //results limit
        $limit = 50;

        //get results and save for tbs block merging
        $this->data['reg_blocks'][] = 'mytask';
        $this->data['blocks']['mytask'] = $this->tasks_model->myPendingTasks($limit);


        //visibility - show table or show nothing found
        if (count($this->data['blocks']['mytask']) > 0) {
            $this->data['visible']['wi_tasks_seemore_link'] = 1;
            $this->data['visible']['wi_tasks_chart'] = 1;
        } else {
            $this->data['visible']['wi_tasks_none'] = 1;
        }

    }

    /**
     * edit a task
     */
    function __editTask()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //flow control
        $next = true;

        //check if any post data (avoid direct url access)
        if (!isset($_POST['submit'])) {
            redirect('/admin/home');
        }

        /** PERMISSION CHECK
         *  only the following users can carry out this action
         *  (1) owner of the task
         *  (2) global admin
         *  (3) project leader
         */
        if ($next) {

            //get task super users
            $superusers = $this->tasks_model->superUsers($this->input->post('tasks_id'));
            $this->data['task_super_users'] = $superusers; //just for debugging


            //check if team member has permission to edit
            if (in_array($this->data['vars']['my_id'], $superusers) || $this->data['vars']['my_group'] == 1) {

                //permission granted
                $next = true;

            } else {

                //permission denied
                $this->notices('error', $this->data['lang']['lang_permission_denied'], 'noty');

                //halt
                $next = false;
            }

        }

        //validate form & display any errors
        if ($next) {
            if (!$this->__flmFormValidation('edit_task')) {

                //show error
                $this->notices('error', $this->form_processor->error_message);
                $next = false;
            }
        }

        //validate hidden fields
        if ($next) {
            if (!is_numeric($_POST['tasks_id']) || $_POST['tasks_events_id'] == '') {

                //log this error
                $this->__errorLogging(__line__, __function__, __file__, 'Editing task failed: [Some or All] Required hidden form fileds missing or invalid');

                //show error
                $this->notices('error', $this->data['lang']['lang_request_could_not_be_completed'], 'noty');

                $next = false;
            }
        }

        //check end date is not behind start date
        if ($next) {

            if (strtotime($this->input->post('tasks_end_date')) < strtotime($this->input->post('tasks_start_date'))) {

                //show error
                $this->notices('error', $this->data['lang']['lang_end_date_cannot_be_before_start_date'], 'noty');

                $next = false;
            }
        }

        //edit task
        if ($next) {
            if ($this->tasks_model->editTask()) {
                //show success
                $this->notices('success', $this->data['lang']['lang_request_has_been_completed'], 'noty');
            } else {
                //show error
                $this->notices('error', $this->data['lang']['lang_request_could_not_be_completed'], 'noty');
            }
        }


        //refresh project progress
        if ($next) {
            if (isset($_POST['task_project_id']) && is_numeric($_POST['task_project_id'])) {
                $this->refresh->updateProjectPercentage($this->input->post('task_project_id'));
                $this->data['debug'][] = $this->refresh->debug_data;
            }
        }

        //show task page
        $this->__home();
    }

    /**
     * get ann events from my projects
     */
    function __getEventsTimeline()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //flow control
        $next = true;

        //try to create 'comma separated' list of my projects
        if ($next) {

            //check if I have projects
            if ($this->data['vars']['my_projects_list']) {

                //get project events (timeline)
                $this->data['reg_blocks'][] = 'timeline';
                $this->data['blocks']['timeline'] = $this->project_events_model->getEvents($this->data['vars']['my_projects_list'], 'project-list');


                //further process events data
                $this->data['blocks']['timeline'] = $this->__prepEvents($this->data['blocks']['timeline']);

                //show timeline
                $this->data['visible']['show_timeline'] = 1;

            } else {

                //show no events found
                $this->data['visible']['show_no_timeline'] = 1;
            }

        }

    }

    /**
     * additional data preparations project events (timeline) data
     */
    function __prepEvents($thedata = '')
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //check if data is not empty
        if (count($thedata) == 0 || !is_array($thedata)) {
            return $thedata;
        }

        /* -----------------------PREPARE FILES DATA ----------------------------------------/
        *  Loop through all the files in this array and for each file:
        *  -----------------------------------------------------------
        *  (1) process user names ('event by' data)
        *  (2) add back the language for the action carried out
        *
        *
        *------------------------------------------------------------------------------------*/
        for ($i = 0; $i < count($thedata); $i++) {

            //--team member---------------------
            if ($thedata[$i]['project_events_user_type'] == 'team') {
                $thedata[$i]['user_name'] = $thedata[$i]['team_profile_full_name'];
                $thedata[$i]['avatar'] = $thedata[$i]['team_profile_avatar_filename'];
            }

            //--client user---------------------
            if ($thedata[$i]['project_events_user_type'] == 'client') {
                $thedata[$i]['user_name'] = $thedata[$i]['client_users_full_name'];
                $thedata[$i]['avatar'] = $thedata[$i]['client_users_avatar_filename'];
            }

            //add back langauge
            $word = $thedata[$i]['project_events_action'];
            $thedata[$i]['project_events_action_lang'] = $this->data['lang'][$word];

            //add #hash to numbers (e.g invoice number) and create a new key called 'project_events_item'
            if (is_numeric($thedata[$i]['project_events_details'])) {
                $thedata[$i]['project_events_item'] = '#' . $thedata[$i]['project_events_details'];
            } else {
                $thedata[$i]['project_events_item'] = $thedata[$i]['project_events_details'];
            }

        }

        //retun the processed data
        return $thedata;
    }

    /**
     * validates forms for various methods in this class
     * 
     * @param string $form identify the form to validate
     */
    function __flmFormValidation($form = '')
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //form validation
        if ($form == 'edit_task') {

            //check required fields
            $fields = array(
                'tasks_text' => $this->data['lang']['lang_title'],
                'tasks_start_date' => $this->data['lang']['lang_start_date'],
                'tasks_end_date' => $this->data['lang']['lang_end_date'],
                'tasks_milestones_id' => $this->data['lang']['lang_milestone'],
                'tasks_assigned_to_id' => $this->data['lang']['lang_assigned_to']);
            if (!$this->form_processor->validateFields($fields, 'required')) {
                return false;
            }

            //everything ok
            return true;
        }

        //nothing specified - return false & error message
        $this->form_processor->error_message = $this->data['lang']['lang_form_validation_error'];
        return false;

    }


    /**
     * Generates various pulldown (<option>...</option>) lists for ready use in HTML
     * Output is set to e.g. $this->data['lists']['milestones']
     *
     */
    function __pulldownLists()
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //[all_my_projects]
        $sqldata = array();
        $sqldata['projects_status'] = 'open';
        $sqldata['project_members_team_id'] = $this->data['vars']['my_id'];
        $data = $this->projects_model->getMembersProjects($sqldata);
        $this->data['lists']['all_my_projects'] = create_pulldown_list($data, 'projects', 'id');
    }


    /**
     * loads the view
     *
     * @param string $view the view to load
     */
    function __flmView($view = '')
    {

        //profiling
        $this->data['controller_profiling'][] = __function__;

        //template::
        $this->data['template_file'] = help_verify_template($this->data['template_file']);

        //post data
        $this->data['post'] = $_POST;

        //get data
        $this->data['get'] = $_GET;

        //url segmets array
        $this->data['url_segments'] = $this->uri->segment_array();

        $this->load->view($view, array('data' => $this->data));
    }

}

/* End of file home.php */
/* Location: ./application/controllers/admin/home.php */
